import osc.OscMessage;
import osc.OscPacket;

import java.io.IOException;
import java.util.Vector;
import java.util.StringTokenizer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.DatagramSocket;
import java.net.DatagramPacket;
import java.net.SocketException;


public class OscSender {
    private 	DatagramSocket 		socket	= null;
    private		BApplet				parent;				
    public 		String 				ip;
    public		InetAddress 		addr; 
    public		int					port; 
	
	OscSender() {}
	
    public OscSender(	BApplet parent,
    					String addr,
    					int  port
    					) {
    		
    	this.parent 		= parent;
    	try {
        	this.addr 			= InetAddress.getByName(addr);
       	} catch (UnknownHostException e) { 
    		System.out.println("ERROR while initializing host "+e);
    	}
    	
    	try {
			this.socket 		= new DatagramSocket();
		} catch (SocketException e) { 
    		System.out.println("ERROR while creating socket "+e);
    	}
        this.port			= port;
        System.out.println("osc sender initialized.");
    }

	
    public void sendMsg(String msgName, Vector types, Vector args) {
    	sendPacket(preparePacket(msgName,types,args,this.addr,this.port));
    }
    
    public void sendMsg(MessageOUT msg) {
    	sendPacket(preparePacket(msg.msgName,msg.types,msg.args,this.addr,this.port));
    }
    
    public void sendMsg(MessageOUT msg,String addr,int port) {
    	try {
    		InetAddress tmpAddr = InetAddress.getByName(addr);
    		sendPacket(preparePacket(msg.msgName,msg.types,msg.args,tmpAddr,port));
    	} catch (UnknownHostException e) { 
    		System.out.println("ERROR while sending packet "+e);
    	}
    }
    
    
    
    public OscPacket preparePacket(String msgName, Vector types, Vector args,InetAddress addr, int port) {
    	// System.out.println(msgName+" "+types+" "+args+"  "+addr+"  "+port);
    	OscPacket packet = new OscPacket(Long.parseLong("0"), addr, port);
    	OscMessage message 	= new OscMessage(msgName);
    	message.setTypesAndArgs(types,args);
    	if (types.size()==args.size()) {
    		message.setTypesAndArgs(types,args);
    	}
    	packet.addMessage(message);
    	/*
    	try {
    		OscPacket.printBytes( packet.getByteArray() );
    	} catch(IOException ioe) {
			System.out.println("Server error...Stopping OSC receiver");
		}
		*/
    	return packet;
    }
    
    
    public void sendPacket(OscPacket oscPacket)  {
    	try {
    		byte[] byteArray = oscPacket.getByteArray();
        	DatagramPacket packet = new DatagramPacket( byteArray, byteArray.length,oscPacket.getAddress(),oscPacket.getPort());
			socket.send(packet);
			
		} catch(SocketException se) {
       		System.out.println(" sendMsg() ERROR, SocketException");
       	} catch(IOException ioe) {
           	System.out.println(" sendMsg() ERROR, io exception");
       	} catch(NullPointerException npe) {
           	System.out.println(" sendMsg() ERROR, NullPointerException");
       	} 
    }
    
    
}


	
	class MessageOUT {
				String		msgName	= "";
		final 	Character	TYPE_I	= new Character('i');
		final 	Character 	TYPE_S	= new Character('s');
		final 	Character 	TYPE_F	= new Character('f');
		final 	Character 	TYPE_t	= new Character('T');
		final 	Character 	TYPE_f	= new Character('F');
		final	Character	TYPE_O	= new Character('[');
		final	Character	TYPE_C	= new Character(']');
				Vector 		types	= new Vector();
				Vector		args	= new Vector();
		
		MessageOUT(String s) {
			this.msgName = s;
		}
		
		/*
		void add(Vector args[]) {
		}
		*/
		
		void add(int i) {
			this.types.add(TYPE_I);
			this.args.add(new Integer(i));
		}
		
		void add(String s) {
			this.types.add(TYPE_S);
			this.args.add(s);
		}
		
		
		void add(float f) {
			this.types.add(TYPE_F);
			this.args.add(new Float(f));
		}
		
		void add(boolean b) {
			if (b==true) {
				this.types.add(TYPE_t);
			} else {
				this.types.add(TYPE_f);
			}
		}
		
		void add(Integer i) {
			this.types.add(TYPE_I);
			this.args.add(i);
		}
		
		void add(Float f) {
			this.types.add(TYPE_F);
			this.args.add(f);
		}
		
		void add(int[] arr) {
			this.types.add(TYPE_O);
			for(int i=0;i<arr.length;i++) {
				add(arr[i]);
			}
			this.types.add(TYPE_C);
		}
		
		void add(float[] arr) {
			this.types.add(TYPE_O);
			for(int i=0;i<arr.length;i++) {
				add(arr[i]);
			}
			this.types.add(TYPE_C);
		}
		
		void add(String[] arr) {
			this.types.add(TYPE_O);
			for(int i=0;i<arr.length;i++) {
				add(arr[i]);
			}
			this.types.add(TYPE_C);
		}
		
		
		void add(Vector v) {
			this.types.add(TYPE_O);
			for(int i=0;i<v.size();i++) {
				 if (v.elementAt(i) instanceof String) {
					add((String)v.elementAt(i));
				} else if (v.elementAt(i) instanceof Integer) {
					add((Integer)v.elementAt(i));
				} else if (v.elementAt(i) instanceof Float) {
					add((Float)v.elementAt(i));
				} else if (v.elementAt(i) instanceof Vector) {
					add((Vector)v.elementAt(i));
				} else {
					System.out.println("NOT DEFINED OBJECT");
				}
			}
			this.types.add(TYPE_C);
		}
		
		void printMessage() {
			System.out.println("OUT --- "+this.msgName+"  "+types+"   "+args);
		}
		
	}