package osc;

import java.util.Vector;
import java.util.Enumeration;
import java.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;


// for program description and credits, see the sjmComm_readme.txt


public class OscPacket {
    private long time;
    private Vector messages;
    public InetAddress address;
    public int port;
	public String msgName = "/error";
	
    /*
    Constructor for all incoming packets and those outgoing packets
    whose time, address, and port will be set later.
    */
    public OscPacket() {
	time = 0;
	messages = new Vector();
    }


    // Constructor for outgoing packets.
    
    public OscPacket(long time, InetAddress address, int port) {
		this.time = time;
		messages = new Vector();
		this.address = address;
		this.port = port;
    }

	
    // Sets the time.
    public void setTime(long time) {
	this.time = time;
    }


    /*
    Sets the destination address.
    */
    public void setAddress(InetAddress address) {
	this.address = address;
    }

    /*
    Sets the destination port.
    */
    public void setPort(int port) {
	this.port = port;
    }


    /*
    Adds a message to this packet.
    */
    public void addMessage(OscMessage message) {
		messages.addElement(message);
    }
	
    public InetAddress getAddress() {
	return address;
    }

    public int getPort() {
	return port;
    }

	
	
	/*
		Returns an XML representation of this packet, suitable for
		sending to a tcp Client. The return value should validate against
		tcpOsc.dtd
	*/
   
    public Vector extractPacket() {
    	Vector returnVector = new Vector();
		/*
		Vector returnXML		= new Vector();
		String packetContent	= "";
		String msgName 			= "";
		*/
		
		boolean firstMsgFlag 	= true;
		String firstMsgName 	= "";
		
		int tmpCount = 0;
		Enumeration m = messages.elements();
		while (m.hasMoreElements()) {
			String packetContent = "";
	    	OscMessage mess = (OscMessage)m.nextElement();
	    	Vector tmpVector = new Vector();
	    	tmpVector.addElement(mess.getName());
	    	tmpVector.addElement(mess.getTypes());
	    	tmpVector.addElement(mess.getArgs());
	    	
	    	returnVector.addElement(tmpVector);
	    	
	    	if (firstMsgFlag==true) {
	    		firstMsgName = msgName;
	    		firstMsgFlag = false;
	    	}
	    	//System.out.println(packetContent);
	    	tmpCount++;
		}
		return returnVector;
    }
    
    
	
    /*
    Returns a byte array representation of this packet, suitable for
    sending to OSC client applications.
    */
    public byte[] getByteArray() throws IOException {
	ByteArrayOutputStream baos = new ByteArrayOutputStream();
	DataOutputStream stream = new DataOutputStream(baos);
	
        
	/*
		boolean isBundle
		when sending a bundle, the alignStream should not be
		added to the packet, as it causes errors in supercollider 2,
		and causes supercollider 3 to crash.
		added by andreas schlegel
	*/
	boolean isBundle = false;
	// bundle
      	if (messages.size() > 1) {
	    baos.write( ("#bundle").getBytes() );
	    baos.write(0);
	    isBundle=true;
	    // bundles have a time tag
	    stream.writeLong(time);
	}

	// messages
	Enumeration m = messages.elements();
	while (m.hasMoreElements()) {
	    OscMessage mess = (OscMessage)m.nextElement();
	    byte[] byteArray = mess.getByteArray();
	    // bundles have message size tags
	    if (messages.size() > 1) {
		stream.writeInt(byteArray.length);
	    }
	    baos.write(byteArray);
	}
		/*
			alignStream causes errors with REAKTOR
			so far all test worked without alignStream
			uncommenting the next line adds 4 0-bytes
			at the end of an outgoing message 
		*/
	// if (isBundle==false) alignStream(baos);
	return baos.toByteArray();
    }

    
    /*
    Make the stream end on a 4-byte boundary by padding it with
    null characters.
    */
    private void alignStream(ByteArrayOutputStream stream) throws IOException {
        int pad = 4 - ( stream.size() % 4 );
        for (int i = 0; i < pad; i++)
            stream.write(0);
    }

    /*
    Prints out a byte array in 4-byte lines, useful for debugging.
    */
    public static void printBytes(byte[] byteArray) {
		for (int i=0; i<byteArray.length; i++) {
		    System.out.print(byteArray[i] + " (" + (char)byteArray[i] + ")  ");
		    if ((i+1)%4 == 0)
			System.out.print("\n");
		}
    }


}

