package osc;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.InetAddress;
import java.io.IOException;


// for program description and credits, see the sjmComm_readme.txt

/*
OscSocket is for sending OSC packets
*/


public class OscSocket extends DatagramSocket {

    public OscSocket() throws SocketException {
		super();
    }

    /*
    The only override, to send an OscPacket
    */
    
    public void send(OscPacket oscPacket) throws IOException {
        byte[] byteArray = oscPacket.getByteArray();
		// DEBUG
		System.out.println("OscSocket about to send this packet:");
		OscPacket.printBytes(byteArray);
        DatagramPacket packet = new DatagramPacket( byteArray, byteArray.length,oscPacket.getAddress(), oscPacket.getPort() );
        super.send(packet);
    }
}
